/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.sgtree;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BoundingLeaf;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Clip;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Leaf;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.LineAttributes;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Morph;
import org.xith3d.scenegraph.OrderedGroup;
import org.xith3d.scenegraph.PointAttributes;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.SceneGraphObject;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Sound;
import org.xith3d.scenegraph.SpotLight;
import org.xith3d.scenegraph.Switch;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.utility.sgtree.infoitems.SGTInfo_Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGTree
extends JFrame
implements TreeSelectionListener {
    private static final long serialVersionUID = -3374869095150421975L;
    private JEditorPane m_TextPane = null;
    private JSplitPane m_SplitPane = null;
    private JTree m_Tree = null;
    private static final String INFO_PACKAGE_NAME = SGTInfo_Object.class.getPackage().getName() + ".";
    private Map<String, Object> m_ObjectInfoTable = new Hashtable<String, Object>(64);

    public SGTree() {
        super("Xith3D Scenegraph Tree");
        this.buildObjectInfoTable();
    }

    private void buildObjectInfoTable() {
        this.m_ObjectInfoTable = new Hashtable<String, Object>(64);
        this.addObjectInfoTableItem(AmbientLight.class);
        this.addObjectInfoTableItem(Appearance.class);
        this.addObjectInfoTableItem(BoundingLeaf.class);
        this.addObjectInfoTableItem(BranchGroup.class);
        this.addObjectInfoTableItem(ColoringAttributes.class);
        this.addObjectInfoTableItem(Clip.class);
        this.addObjectInfoTableItem(DirectionalLight.class);
        this.addObjectInfoTableItem(Fog.class);
        this.addObjectInfoTableItem(Group.class);
        this.addObjectInfoTableItem(Leaf.class);
        this.addObjectInfoTableItem(Light.class);
        this.addObjectInfoTableItem(LineAttributes.class);
        this.addObjectInfoTableItem(Material.class);
        this.addObjectInfoTableItem(Morph.class);
        this.addObjectInfoTableItem(GroupNode.class);
        this.addObjectInfoTableItem(OrderedGroup.class);
        this.addObjectInfoTableItem(PointAttributes.class);
        this.addObjectInfoTableItem(PointLight.class);
        this.addObjectInfoTableItem(PolygonAttributes.class);
        this.addObjectInfoTableItem(RenderingAttributes.class);
        this.addObjectInfoTableItem(SceneGraphObject.class);
        this.addObjectInfoTableItem(Shape3D.class);
        this.addObjectInfoTableItem(Sound.class);
        this.addObjectInfoTableItem(SpotLight.class);
        this.addObjectInfoTableItem(Switch.class);
        this.addObjectInfoTableItem(TexCoordGeneration.class);
        this.addObjectInfoTableItem(Texture.class);
        this.addObjectInfoTableItem(TextureAttributes.class);
        this.addObjectInfoTableItem(Transform3D.class);
        this.addObjectInfoTableItem(TransformGroup.class);
        this.addObjectInfoTableItem(TransparencyAttributes.class);
    }

    private void addObjectInfoTableItem(Class<?> sgClass) {
        String className = sgClass.getName();
        String infoClassName = INFO_PACKAGE_NAME + "SGTInfo_" + sgClass.getSimpleName();
        Class<?> classObject = this.getClass(infoClassName);
        try {
            if (classObject != null) {
                this.m_ObjectInfoTable.put(className, classObject.newInstance());
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("Unable to create a new instance of info class for: " + className);
    }

    SGTInfo_Object getObjectInfo(String szClass) {
        SGTInfo_Object objReturn = (SGTInfo_Object)this.m_ObjectInfoTable.get(szClass);
        Class<?> classObject = null;
        try {
            classObject = Class.forName(szClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Class<?> parentClass = null;
        if (classObject != null) {
            parentClass = classObject.getSuperclass();
        }
        while (objReturn == null && parentClass != null) {
            objReturn = (SGTInfo_Object)this.m_ObjectInfoTable.get(parentClass.getName());
            parentClass = parentClass.getSuperclass();
        }
        return objReturn;
    }

    private Class<?> getClass(String infoClass) {
        Class<?> classObject = null;
        try {
            classObject = Class.forName(infoClass);
        }
        catch (Exception e) {
            try {
                classObject = Class.forName(INFO_PACKAGE_NAME + "SGTInfo_Object");
            }
            catch (Exception e2) {
                classObject = null;
            }
        }
        return classObject;
    }

    public void recurseObject(Object obj, DefaultMutableTreeNode parent) {
        if (obj != null) {
            SGTInfo_Object objInfo = this.getObjectInfo(obj.getClass().getName());
            if (objInfo != null) {
                objInfo.addToTree(this, parent, obj);
            }
        } else {
            System.err.println("Warning: ignored null object in recurseObject.");
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)this.m_Tree.getLastSelectedPathComponent();
        if (node2 == null) {
            return;
        }
        Object sceneGraphObject = node2.getUserObject();
        SGTInfo_Object objInfo = this.getObjectInfo(sceneGraphObject.getClass().getName());
        try {
            if (objInfo != null) {
                String szText = objInfo.getInfo(sceneGraphObject);
                this.displayText(szText);
            } else {
                this.displayText("No Info Handler for:" + sceneGraphObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.displayText(ex.toString());
        }
    }

    private void displayText(String szText) {
        this.m_TextPane.setText(szText);
    }

    public void updateNodes(SceneGraph sceneGraph) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Scenegraph");
        int n = sceneGraph.getNumberOfBranchGroups();
        for (int i = 0; i < n; ++i) {
            this.recurseObject(sceneGraph.getBranchGroup(i), top);
        }
        this.m_Tree = new JTree(top);
        this.m_Tree.getSelectionModel().setSelectionMode(1);
        this.m_Tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.m_Tree);
        Dimension minimumSize = new Dimension(100, 50);
        treeView.setMinimumSize(minimumSize);
        if (this.m_SplitPane == null) {
            this.m_TextPane = new JEditorPane();
            this.m_TextPane.setEditable(false);
            JScrollPane htmlView = new JScrollPane(this.m_TextPane);
            this.m_SplitPane = new JSplitPane(0);
            this.m_SplitPane.setTopComponent(treeView);
            this.m_SplitPane.setBottomComponent(htmlView);
            htmlView.setMinimumSize(minimumSize);
            this.m_SplitPane.setDividerLocation(100);
            this.m_SplitPane.setPreferredSize(new Dimension(500, 300));
            this.getContentPane().add((Component)this.m_SplitPane, "Center");
            this.pack();
            this.setVisible(true);
        } else {
            this.m_SplitPane.setTopComponent(treeView);
        }
    }
}

