/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.texturing;

import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Texture;

public class CubeTextureSet {
    public static final int FRONT_INDEX = 0;
    public static final int RIGHT_INDEX = 1;
    public static final int BACK_INDEX = 2;
    public static final int LEFT_INDEX = 3;
    public static final int TOP_INDEX = 4;
    public static final int BOTTOM_INDEX = 5;
    private String[] textureNames;
    private Texture[] textures;
    private TextureLoader.FlipMode flipMode;

    public void setFlipMode(TextureLoader.FlipMode flipMode) {
        this.flipMode = flipMode;
    }

    public TextureLoader.FlipMode getFlipMode() {
        return this.flipMode;
    }

    public String[] getTextureNames() {
        return this.textureNames;
    }

    public Texture[] getTextures() {
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = TextureLoader.getInstance().getTexture(this.textureNames[i], this.getFlipMode());
        }
        return this.textures;
    }

    public void setFront(Texture texture) {
        if (texture.getResourceName() == null) {
            throw new NullPointerException("The given Texture does not have resource name.");
        }
        this.textureNames[0] = texture.getResourceName();
    }

    public void setFront(String textureName) {
        if (textureName == null) {
            throw new NullPointerException("The given Texture-Name must not be null.");
        }
        this.textureNames[0] = textureName;
    }

    public String getFront() {
        return this.textureNames[0];
    }

    public Texture getFrontTexture() {
        return TextureLoader.getInstance().getTexture(this.getFront(), this.getFlipMode());
    }

    public void setRight(Texture texture) {
        if (texture.getResourceName() == null) {
            throw new NullPointerException("The given Texture does not have resource name.");
        }
        this.textureNames[1] = texture.getResourceName();
    }

    public void setRight(String textureName) {
        if (textureName == null) {
            throw new NullPointerException("The given Texture-Name must not be null.");
        }
        this.textureNames[1] = textureName;
    }

    public String getRight() {
        return this.textureNames[1];
    }

    public Texture getRightTexture() {
        return TextureLoader.getInstance().getTexture(this.getRight(), this.getFlipMode());
    }

    public void setBack(Texture texture) {
        if (texture.getResourceName() == null) {
            throw new NullPointerException("The given Texture does not have resource name.");
        }
        this.textureNames[2] = texture.getResourceName();
    }

    public void setBack(String textureName) {
        if (textureName == null) {
            throw new NullPointerException("The given Texture-Name must not be null.");
        }
        this.textureNames[2] = textureName;
    }

    public String getBack() {
        return this.textureNames[2];
    }

    public Texture getBackTexture() {
        return TextureLoader.getInstance().getTexture(this.getBack(), this.getFlipMode());
    }

    public void setLeft(Texture texture) {
        if (texture.getResourceName() == null) {
            throw new NullPointerException("The given Texture does not have resource name.");
        }
        this.textureNames[3] = texture.getResourceName();
    }

    public void setLeft(String textureName) {
        if (textureName == null) {
            throw new NullPointerException("The given Texture-Name must not be null.");
        }
        this.textureNames[3] = textureName;
    }

    public String getLeft() {
        return this.textureNames[3];
    }

    public Texture getLeftTexture() {
        return TextureLoader.getInstance().getTexture(this.getLeft(), this.getFlipMode());
    }

    public void setTop(Texture texture) {
        if (texture.getResourceName() == null) {
            throw new NullPointerException("The given Texture does not have resource name.");
        }
        this.textureNames[4] = texture.getResourceName();
    }

    public void setTop(String textureName) {
        if (textureName == null) {
            throw new NullPointerException("The given Texture-Name must not be null.");
        }
        this.textureNames[4] = textureName;
    }

    public String getTop() {
        return this.textureNames[4];
    }

    public Texture getTopTexture() {
        return TextureLoader.getInstance().getTexture(this.getTop(), this.getFlipMode());
    }

    public void setBottom(Texture texture) {
        if (texture.getResourceName() == null) {
            throw new NullPointerException("The given Texture does not have resource name.");
        }
        this.textureNames[5] = texture.getResourceName();
    }

    public void setBottom(String textureName) {
        if (textureName == null) {
            throw new NullPointerException("The given Texture-Name must not be null.");
        }
        this.textureNames[5] = textureName;
    }

    public String getBottom() {
        return this.textureNames[5];
    }

    public Texture getBottomTexture() {
        return TextureLoader.getInstance().getTexture(this.getBottom(), this.getFlipMode());
    }

    public CubeTextureSet(String[] textureNames, TextureLoader.FlipMode flipMode) {
        if (textureNames.length != 6) {
            throw new IllegalArgumentException("the given array must be of length 6.");
        }
        this.textureNames = new String[6];
        for (int i = 0; i < 6; ++i) {
            if (textureNames[i] == null) {
                throw new NullPointerException("None of the geven texture names must be null (#" + i + " is).");
            }
            this.textureNames[i] = textureNames[i];
        }
        this.textures = new Texture[6];
        this.flipMode = flipMode;
    }

    public CubeTextureSet(String[] textureNames) {
        this(textureNames, TextureLoader.FlipMode.FLIPPED_VERTICALLY);
    }

    public CubeTextureSet(String texFront, String texRight, String texBack, String texLeft, String texTop, String texBottom, TextureLoader.FlipMode flipMode) {
        this.textureNames = new String[]{texFront, texRight, texBack, texLeft, texTop, texBottom};
        for (int i = 0; i < 6; ++i) {
            if (this.textureNames[i] != null) continue;
            throw new NullPointerException("None of the geven texture names must be null (#" + i + " is).");
        }
        this.textures = new Texture[6];
        this.flipMode = flipMode;
    }

    public CubeTextureSet(String texFront, String texRight, String texBack, String texLeft, String texTop, String texBottom) {
        this(texFront, texRight, texBack, texLeft, texTop, texBottom, (TextureLoader.FlipMode)null);
    }

    public CubeTextureSet(Texture texFront, Texture texRight, Texture texBack, Texture texLeft, Texture texTop, Texture texBottom, TextureLoader.FlipMode flipMode) {
        this.textureNames = new String[]{texFront.getResourceName(), texRight.getResourceName(), texBack.getResourceName(), texLeft.getResourceName(), texTop.getResourceName(), texBottom.getResourceName()};
        for (int i = 0; i < 6; ++i) {
            if (this.textureNames[i] != null) continue;
            throw new NullPointerException("All of the given textures must have names (#" + i + " doesn't).");
        }
        this.textures = new Texture[6];
        this.flipMode = flipMode;
    }

    public CubeTextureSet(Texture texFront, Texture texRight, Texture texBack, Texture texLeft, Texture texTop, Texture texBottom) {
        this(texFront, texRight, texBack, texLeft, texTop, texBottom, (TextureLoader.FlipMode)null);
    }

    public static CubeTextureSet create(String baseName, String extension, TextureLoader.FlipMode flipMode) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        return new CubeTextureSet(baseName + "front" + extension, baseName + "right" + extension, baseName + "back" + extension, baseName + "left" + extension, baseName + "top" + extension, baseName + "bottom" + extension, flipMode);
    }

    public static CubeTextureSet create(String baseName, String extension) {
        return CubeTextureSet.create(baseName, extension, null);
    }
}

