/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.w3g;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.render.Renderer;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.OrderedGroup;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Origin;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.ui.hud.widgets.assemblies.LoadingScreen;

public class ColorCube
extends InputAdapterRenderLoop {
    private final float SCALE = 5.0f;
    private final float HALF_SIZE = 4.0f;
    private Canvas3D canvas;
    private final TransparencyAttributes transAttribs = new TransparencyAttributes(TransparencyAttributes.BLENDED, 0.5f);
    private final RenderingAttributes renderAttribs = new RenderingAttributes();
    private final PolygonAttributes polyAttribs = new PolygonAttributes(FaceCullMode.SWITCH);

    public ColorCube() throws Exception {
        Vector3f eyePosition = new Vector3f(40.0f, 40.0f, 40.0f);
        Vector3f viewFocus = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vecUp = new Vector3f(0.0f, 0.0f, 1.0f);
        Xith3DEnvironment env = new Xith3DEnvironment(eyePosition, viewFocus, vecUp, this);
        env.getRenderer().setTransparentSortingPolicy(Renderer.TransparentSortingPolicy.SORT_NONE);
        OpenGLLayer oglLayer = OpenGLLayer.JOGL_AWT;
        this.canvas = Canvas3DFactory.createWindowed(oglLayer, 800, 600, false, "Color cube");
        this.canvas.setIcon(this.getClass().getClassLoader().getResource("org/xith3d/w3g/ColorCube.gif"));
        env.addCanvas(this.canvas);
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        BranchGroup mainBranch = new BranchGroup();
        env.addBranchGraph(mainBranch, new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION));
        mainBranch.addChild(new Origin());
        ResourceLocator resLoc = ResourceLocator.create("test-resources/");
        resLoc.createAndAddTSL("HUD");
        int max = 40;
        LoadingScreen ls = LoadingScreen.createWithHUD((Sized2iRO)this.canvas, "BlueBackground.jpg", max);
        ls.setRenderLoopController(this);
        env.addRenderPass(ls.getRenderPass());
        RotatableGroup rg = this.createColorCube(ls);
        mainBranch.addChild(rg);
        this.getAnimator().addAnimatableObject(rg);
        env.removeRenderPass(ls.getRenderPass());
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        this.begin();
    }

    private RotatableGroup createColorCube(LoadingScreen ls) {
        ls.update(0, "Loading color cube...");
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(-0.05f, -0.015f, 0.0f));
        OrderedGroup og = new OrderedGroup();
        rg.addChild(og);
        Geometry geom = Sphere.createGeometry(0.0f, 0.0f, 0.0f, 4.5f, 10, 10, 1, false, 2);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        for (float x = -20.0f; x <= 20.0f; x += 5.0f) {
            for (float y = -20.0f; y <= 20.0f; y += 5.0f) {
                for (float z = -20.0f; z <= 20.0f; z += 5.0f) {
                    if (Math.abs(x) != 20.0f && Math.abs(y) != 20.0f && Math.abs(z) != 20.0f) continue;
                    Shape3D sph = new Shape3D(geom, this.getAppearance(x, y, z));
                    og.addChild(new Transform().setTranslation(x, y, z).add(sph));
                }
            }
            ls.update((int)(x + 20.0f));
        }
        return rg;
    }

    private final RenderingAttributes getRenderingAttribs() {
        this.renderAttribs.setAlphaWriteEnabled(false);
        return this.renderAttribs;
    }

    private Appearance getAppearance(float x, float y, float z) {
        Appearance app = new Appearance();
        float r = (x + 4.0f) / 4.0f / 5.0f;
        float g = (y + 4.0f) / 4.0f / 5.0f;
        float b = (z + 4.0f) / 4.0f / 5.0f;
        app.setColoringAttributes(new ColoringAttributes(new Colorf(r, g, b), ColoringAttributes.SHADE_GOURAUD));
        app.setTransparencyAttributes(this.transAttribs);
        app.setRenderingAttributes(this.getRenderingAttribs());
        app.setPolygonAttributes(this.polyAttribs);
        return app;
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.canvas.takeScreenshot(false);
            }
        }
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new ColorCube();
    }
}

