/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.w3g;

import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.primitives.Cylinder;
import org.xith3d.scenegraph.primitives.Origin;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.debug.DebugCenter;
import org.xith3d.utility.physics.pseudo.joints.HingeJoint;

public class Physics
extends InputAdapterRenderLoop {
    private Xith3DEnvironment env = new Xith3DEnvironment(this);
    private HingeJoint hinge1;
    private HingeJoint hinge2;
    private HingeJoint hinge3;
    private float inc1;
    private float inc2;
    private float inc3;
    private static final Random RANDOM = new Random(System.nanoTime());
    private static final float ANGLE_LIMIT = FastMath.toRad(75.0f);

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    protected void init(Xith3DEnvironment env) {
        env.getView().lookAt(40.0f, 40.0f, 80.0f, 0.0f, 0.0f, 40.0f, 0.0f, 0.0f, 1.0f);
        int features = 5;
        boolean colorAlpha = false;
        int slices = 10;
        int stacks = 10;
        float alpha = 1.0f;
        BranchGroup scene = new BranchGroup();
        scene.addChild(new Origin());
        this.hinge1 = new HingeJoint(Vector3f.POSITIVE_Z_AXIS, Vector3f.POSITIVE_Z_AXIS, 20.0f);
        this.hinge1.getStartGroup().addChild(new Cylinder(3.0f, 20.0f, 1.0f, 10, 5, false, 2));
        this.hinge1.getEndGroup().addChild(new Sphere(3.0f, 10, 10, 5, false, 2));
        scene.addChild(this.hinge1);
        this.hinge2 = new HingeJoint(Vector3f.POSITIVE_X_AXIS, Vector3f.POSITIVE_Z_AXIS, 15.0f);
        this.hinge2.getStartGroup().addChild(new Cylinder(2.0f, 15.0f, 1.0f, 10, 5, false, 2));
        this.hinge2.getEndGroup().addChild(new Sphere(2.0f, 10, 10, 5, false, 2));
        this.hinge1.addChild(this.hinge2);
        this.hinge3 = new HingeJoint(Vector3f.POSITIVE_X_AXIS, Vector3f.POSITIVE_Z_AXIS, 10.0f);
        this.hinge3.getStartGroup().addChild(new Cylinder(1.0f, 10.0f, 1.0f, 10, 5, false, 2));
        this.hinge3.getEndGroup().addChild(new Sphere(1.0f, 10, 10, 5, false, 2));
        this.hinge2.addChild(this.hinge3);
        env.addPerspectiveBranch(scene);
        this.inc1 = 0.5f;
        this.inc2 = 0.3f;
        this.inc3 = -0.8f;
        new DebugCenter(env, this);
    }

    public void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        float delta = timingMode.getSecondsAsFloat(frameTime);
        if (this.hinge1.getAngle() > ANGLE_LIMIT) {
            this.inc1 = -RANDOM.nextFloat();
        } else if (this.hinge1.getAngle() < -ANGLE_LIMIT) {
            this.inc1 = RANDOM.nextFloat();
        }
        if (this.hinge2.getAngle() > ANGLE_LIMIT) {
            this.inc2 = -RANDOM.nextFloat();
        } else if (this.hinge2.getAngle() < -ANGLE_LIMIT) {
            this.inc2 = RANDOM.nextFloat();
        }
        if (this.hinge3.getAngle() > ANGLE_LIMIT) {
            this.inc3 = -RANDOM.nextFloat();
        } else if (this.hinge3.getAngle() < -ANGLE_LIMIT) {
            this.inc3 = RANDOM.nextFloat();
        }
        this.hinge1.addAngle(this.inc1 * delta);
        this.hinge2.addAngle(this.inc2 * delta);
        this.hinge3.addAngle(this.inc3 * delta);
    }

    public Physics(CanvasConstructionInfo canvasInfo) throws Exception {
        super(128.0f);
        this.env.addCanvas(Canvas3DFactory.create(canvasInfo));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.env.getCanvas().getPeer());
        this.init(this.env);
        this.begin();
    }

    public static void main(String[] args) throws Exception {
        new Physics(new CanvasConstructionInfo(Xith3DTest.DEFAULT_DISPLAY_MODE, Xith3DTest.DEFAULT_FULLSCREEN, "Physics"));
    }
}

