/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.xin;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.primitives.Cube;

public class Chapter08b
extends InputAdapterRenderLoop
implements IntervalListener {
    private Appearance app;
    private Texture[] textures;
    private int currTex = 0;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene() {
        Cube cube = new Cube(3.0f);
        StaticTransform.rotateX(cube, FastMath.toRad(35.0f));
        StaticTransform.rotateZ(cube, FastMath.toRad(5.0f));
        this.textures = new Texture[]{TextureLoader.getInstance().getTexture("stone.jpg"), TextureLoader.getInstance().getTexture("rustycan.jpg")};
        this.app = new Appearance();
        this.app.setTexture(this.textures[this.currTex]);
        cube.setAppearance(this.app);
        return new BranchGroup(cube);
    }

    public void onIntervalHit(Interval interval, long gt, long ft, UpdatingThread.TimingMode tm) {
        if (interval.getName().equals("my interval")) {
            this.app.setTexture(this.textures[++this.currTex % 2]);
        }
    }

    public Chapter08b() throws Exception {
        super(120.0f);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = Canvas3DFactory.createWindowed(800, 600, "Intervals");
        env.addCanvas(canvas);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        ResourceLocator resLoc = ResourceLocator.create("test-resources/");
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene());
        this.getOperationScheduler().addInterval(new Interval(3000000L, "my interval"));
        this.getOperationScheduler().addIntervalListener(this);
    }

    public static void main(String[] args) throws Exception {
        Chapter08b rl = new Chapter08b();
        rl.begin();
    }
}

