/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.xin;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.picking.PickingLibrary;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;

public class Chapter09a
extends InputAdapterRenderLoop
implements NearestPickListener {
    private GroupNode pickGroup;
    private Canvas3D canvas;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        System.out.println("You picked a shape called \"" + nearest.getNode().getName() + "\".");
    }

    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("You just picked nothing!");
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        PickingLibrary.pickNearest(this.pickGroup, this.canvas, button, e.getX(), e.getY(), (NearestPickListener)this);
    }

    private BranchGroup createScene(Animator animator) {
        Cube cube = new Cube(3.0f, "stone.jpg");
        cube.setName("my rotating cube");
        TransformationDirectives rotDirecs = new TransformationDirectives(0.3f, 0.2f, 0.0f);
        RotatableGroup rg = new RotatableGroup(rotDirecs);
        rg.addChild(cube);
        animator.addAnimatableObject(rg);
        return new BranchGroup((Node)rg);
    }

    public Chapter09a() throws Exception {
        super(120.0f);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = Canvas3DFactory.createWindowed(800, 600, "Scheduled Picking");
        env.addCanvas(canvas);
        this.canvas = canvas;
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        ResourceLocator resLoc = ResourceLocator.create("test-resources/");
        resLoc.createAndAddTSL("textures");
        this.pickGroup = env.addPerspectiveBranch(this.createScene(this.getAnimator())).getBranchGroup();
        this.begin();
    }

    public static void main(String[] args) throws Exception {
        Chapter09a rl = new Chapter09a();
        rl.begin();
    }
}

