/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.xin;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.utility.screenshots.ScreenshotEngine;

public class Chapter10
extends InputAdapterRenderLoop {
    private ScreenshotEngine shotEngn1;
    private ScreenshotEngine shotEngn2;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case F1: {
                this.shotEngn1.takeScreenshot(false);
                break;
            }
            case F2: {
                this.shotEngn2.takeScreenshot(false);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene(Animator animator) {
        Cube cube = new Cube(3.0f, "stone.jpg");
        TransformationDirectives rotDirecs = new TransformationDirectives(0.3f, 0.2f, 0.0f);
        RotatableGroup rg = new RotatableGroup(rotDirecs);
        rg.addChild(cube);
        animator.addAnimatableObject(rg);
        return new BranchGroup((Node)rg);
    }

    public Chapter10() throws Exception {
        super(120.0f);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = Canvas3DFactory.createWindowed(800, 600, "Screenshots");
        env.addCanvas(canvas);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        ResourceLocator resLoc = ResourceLocator.create("test-resources/");
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene(this.getAnimator()));
        this.shotEngn1 = env.getScreenshotEngine();
        this.shotEngn2 = canvas;
    }

    public static void main(String[] args) throws Exception {
        Chapter10 rl = new Chapter10();
        rl.begin();
    }
}

