import java.util.Vector;

public class Block {

	private String name;
	private Object value;
	private double validity;
	private float priority;
	private Vector<Triggerable> objects;

	private void assign (Object value) {
		this.value = value;
//		if (isArray(value)) this.value = Arrays.copyof(value);
//		else this.value = value.clone();
	}

	public Block (String name, Object value, double validity, float priority) {
		this.name = name;
		assign(value);
		this.validity = validity;
		this.priority = priority;
		this.objects = new Vector<Triggerable>();
	}

	public Block (String name, Object value, double validity) {
        this(name,value,validity,1.0f);
	}

	public Block (String name, Object value) {
        this(name,value,0,1.0f);
	}

    public Block (String name) {
        this(name,null,0,1.0f);
	}
	public String getName() {
		return name;
	}

	public Object getValue() {
		return value;
	}

	public double getValidity() {
		return validity;
	}

	public double getPriority() {
		return priority;
	}

	public void setPriority (float priority) {
		this.priority = priority;
	}

	public void setValue (Object value) {
        setValue(value,0,1.0f);
	}

	public void setValue (Object value, double validity) {
        setValue(value,validity,1.0f);
	}

	public void setValue (Object value, double validity, float priority) {
		this.validity = validity;
		this.priority = priority;
		assign(value);
        for (Triggerable obj : objects) obj.trigger();
	}

	public boolean matchName (String mask) {
		return name.equals(mask);
	}

	public void addTriggerable (Triggerable obj) {
		if (!objects.contains(obj)) objects.add(obj);
	}

}
